/*
 * Decompiled with CFR 0.152.
 */
package com.example.spendcm.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("spendcm.json");
    public int checkIntervalMinutes = 10;
    public List<String> commands = Arrays.asList("say \u670d\u52a1\u5668\u68c0\u6d4b\u523010\u5206\u949f\u5185\u65e0\u73a9\u5bb6\u6d3b\u52a8", "time set day", "weather clear");
    public boolean enabled = true;
    public boolean logToConsole = true;

    public static ModConfig load() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                String content = Files.readString(CONFIG_PATH);
                return (ModConfig)GSON.fromJson(content, ModConfig.class);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ModConfig config = new ModConfig();
        config.save();
        return config;
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)this), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public long getCheckIntervalMillis() {
        return (long)this.checkIntervalMinutes * 60L * 1000L;
    }
}

